#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// rnd alternating T blocks circlesMod01.fsh  by jt   
//https://www.shadertoy.com/view/dsdfDN
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// https://www.shadertoy.com/view/dsdfDN rnd alternating T blocks circles, 2023 by jt
// based on https://www.shadertoy.com/view/ftcfWf Asymmetric Blocks SDF

// Originally inspired by https://www.shadertoy.com/view/Ws3GRs Asymmetric Blocks by Shane.
// Checkerboard tiling of alternating (horizontal vs. vertical) random (double-T-) crossings.
// Function returns minimum and maximum corners of rectangle containing the given point and its id.

// For transition to regular tiling see https://www.shadertoy.com/view/cd2XR3 Limited Asymmetric Blocks SDF.

// 3d variant: https://www.shadertoy.com/view/dscfDl asymmetric blocks bounce spheres

// tags: sdf, random, distance, t, double, block, euclidean, exact, id, alternating, irregular, asymmetric

// The MIT License
// Copyright (c) 2023 Jakob Thomsen
// Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions: The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software. THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

// https://www.shadertoy.com/view/WttXWX "Best" Integer Hash by FabriceNeyret2,
// implementing Chris Wellons https://nullprogram.com/blog/2018/07/31/
uint triple32(uint x)
{
    x ^= x >> 17;
    x *= 0xed5ad4bbU;
    x ^= x >> 11;
    x *= 0xac4c1b51U;
    x ^= x >> 15;
    x *= 0x31848babU;
    x ^= x >> 14;
    return x;
}

float hash(uint x)
{
    return float(triple32(x)) / float(0xffffffffU);
}

float hash(uvec2 v)
{
    //return hash(v.x + triple32(v.y));
    return mix(0.2, 0.8, hash(v.x + triple32(v.y)));
}

float hash(ivec2 v)
{
    return hash(uvec2(v));
}

float hash0(ivec2 v)
{
    return hash(0u+2u*uvec2(v));
}

float hash1(ivec2 v)
{
    return hash(1u+2u*uvec2(v));
}

// TODO: optimize this
vec2 hash2(ivec2 v)
{
    return vec2(hash0(v), hash1(v));
}

float interior_box(vec2 p, vec2 p0, vec2 p1)
{
    vec2 d = abs(p-(p1+p0)/2.0)-(p1-p0)/2.0;
    return min(max(d.x,d.y),0.0);
}

struct block
{
    vec2 p0, p1;
    ivec2 id;
};
/*
block make_block(vec2 v0, vec2 v1, ivec2 tile, bvec2 o)
{
    return
        block
        (
            v0 + vec2(o) - 1.0, v1 + vec2(o),
            tile + ivec2(o)
        );
}

// possibly faster variant (computations only done if really required) but confusing
// Inspired by https://www.shadertoy.com/view/Ws3GRs Asymmetric Blocks by Shane,
// and also by https://www.shadertoy.com/view/tsVGRz Oddtiles (optimized) by stb.
// Checkerboard tiling of alternating (horizontal vs. vertical) random (double-T-) crossings.
// Returns minimum and maximum corners of rectangle containing the given point an tile id.
block blocks(vec2 p) // https://www.shadertoy.com/view/dsdfDN rnd alternating T blocks circles
{
    vec2 q = fract(p); // local coordinates inside tile
    ivec2 tile = ivec2(floor(p)); // global coordinates of tile
    //bool flip = (tile.x % 2) == (tile.y % 2); // XXX breaks on windows XXX
    bool flip = (tile.x & 1) == (tile.y & 1);
    
    ivec2 ow = ivec2(-1, 0); // offset for west tile
    ivec2 oe = ivec2(+1, 0); // offset for east tile
    ivec2 os = ivec2( 0,-1); // offset for south tile
    ivec2 on = ivec2( 0,+1); // offset for north tile

    ivec2 osw = ivec2(0,0); // offset for south-west tile
    ivec2 onw = ivec2(0,1); // offset for north-west tile
    ivec2 ose = ivec2(1,0); // offset for south-east tile
    ivec2 one = ivec2(1,1); // offset for north-east tile

    if(flip) // vertical line goes through
    {
        vec2 l = vec2(hash0(tile), 0); // x-coordinate of vertical line through this tile
        vec2 le = vec2(0, hash1(tile+oe)); // y-coordinate of horizontal line through east tile
        vec2 lw = vec2(0, hash1(tile+ow)); // y-coordinate of horizontal line through west tile

        if(q.x < l.x)
            if(q.y < lw.y) return make_block(vec2(hash0(tile+osw*2-1), 0)+vec2(0, hash1(tile+os)), l+lw, tile, osw); // south-west: x-coordinate of vertical line through south-west tile, y-coordinate of horizontal line through south tile, y-coordinate of horizontal line through west tile
            else           return make_block(vec2(hash0(tile+onw*2-1), 0)+lw, l+vec2(0, hash1(tile+on)), tile, onw); // north-west: x-coordinate of vertical line through north-west tile, y-coordinate of horizontal line through north tile, y-coordinate of horizontal line through west tile
        else
            if(q.y < le.y) return make_block(l+vec2(0, hash1(tile+os)), vec2(hash0(tile+ose*2-1), 0)+le, tile, ose); // south-east: x-coordinate of vertical line through south-east tile, y-coordinate of horizontal line through south tile, y-coordinate of horizontal line through east tile
            else           return make_block(l+le, vec2(hash0(tile+one*2-1), 0)+vec2(0, hash1(tile+on)), tile, one); // north-east: x-coordinate of vertical line through north-east tile, y-coordinate of horizontal line through north tile, y-coordinate of horizontal line through east tile
    }
    else // horizontal line goes through
    {
        vec2 l = vec2(0, hash1(tile)); // y-coordinate of horizontal line through this tile
        vec2 ls = vec2(hash0(tile+os), 0); // x-coordinate of horizontal line through south tile
        vec2 ln = vec2(hash0(tile+on), 0); // x-coordinate of vertical line through north tile

        if(q.y < l.y)
            if(q.x < ls.x) return make_block(vec2(hash0(tile+ow), 0)+vec2(0, hash1(tile+osw*2-1)), ls+l, tile, osw); // south-west: y-coordinate of horizontal line through south-west tile, x-coordinate of vertical line through west tile, x-coordinate of vertical line through south tile
            else           return make_block(ls+vec2(0, hash1(tile+ose*2-1)), vec2(hash0(tile+oe), 0)+l, tile, ose); // south-east: y-coordinate of horizontal line through south-east tile, x-coordinate of vertical line through east tile, x-coordinate of vertical line through south tile
        else
            if(q.x < ln.x) return make_block(vec2(hash0(tile+ow), 0)+l, ln+vec2(0,hash1(tile+onw*2-1)), tile, onw); // north-west: y-coordinate of horizontal line through north-west tile, x-coordinate of vertical line through west tile, x-coordinate of vertical line through north tile
            else           return make_block(ln+l, vec2(hash0(tile+oe), 0)+vec2(0,hash1(tile+one*2-1)), tile, one); // north-east: y-coordinate of horizontal line through north-east tile, x-coordinate of vertical line through east tile, x-coordinate of vertical line through north tile
    }

    return block(vec2(0), vec2(0), ivec2(0)); // this should never be reached
}
*/
vec2 select(bool flip, vec2 v)
{
    return flip ? vec2(v.x, 0) : vec2(0, v.y);
}

vec4 select(bool flip, vec4 v)
{
    return flip ? vec4(v.x, 0, v.z, 0) : vec4(0, v.y, 0, v.w);
}

vec4 swap(bool flip, vec4 v)
{
    return flip ? v.zwxy : v;
}

// Somewhat compact variant - at the cost of readability.
// Inspired by https://www.shadertoy.com/view/Ws3GRs Asymmetric Blocks by Shane,
// and also by https://www.shadertoy.com/view/tsVGRz Oddtiles (optimized) by stb.
// Checkerboard tiling of alternating (horizontal vs. vertical) random (double-T-) crossings.
// Returns minimum and maximum corners of rectangle containing the given point an tile id.
block blocks(vec2 p) // https://www.shadertoy.com/view/dsdfDN rnd alternating T blocks circles
{
    vec2 q = fract(p); // local coordinates inside tile
    ivec2 tile = ivec2(floor(p)); // global coordinates of tile
    //bool flip = (tile.x % 2) == (tile.y % 2); // XXX breaks on windows XXX
    bool flip = (tile.x & 1) == (tile.y & 1); // false: horizontal line goes through, true: vertical line goes through

    vec2 l = hash2(tile); // x/y-coordinate of vertical/horizontal line through this tile

    // /NE\
    // \WS/
    mat2 Mx =
        mat2
        (
            hash0(tile+ivec2( 0,+1)), // x-coordinate of vertical line through north tile
            hash0(tile+ivec2(-1, 0)), // x-coordinate of vertical line through west tile
            hash0(tile+ivec2(+1, 0)), // x-coordinate of vertical line through east tile
            hash0(tile+ivec2( 0,-1)) // x-coordinate of vertical line through south tile
        );
    mat2 My =
        mat2
        (
            hash1(tile+ivec2( 0,+1)), // y-coordinate of horizontal line through north tile
            hash1(tile+ivec2(-1, 0)), // y-coordinate of horizontal line through west tile
            hash1(tile+ivec2(+1, 0)), // y-coordinate of horizontal line through east tile
            hash1(tile+ivec2( 0,-1)) // y-coordinate of horizontal line through south tile
        );

    bvec2 o =
        flip
        ?
        bvec2(q.x < l.x, q.x < l.x ? q.y < /*west*/My[0][1] : q.y < /*east*/My[1][0])
        :
        bvec2(q.y < l.y ? q.x < /*south*/Mx[1][1] : q.x < /*north*/Mx[0][0], q.y < l.y);

    vec2 ll = hash2(tile+ivec2(not(o))*2-1);

    vec4 minmax =
        vec4
        (
            vec2(Mx[int(o.y)][int(o.y)], My[int(o.y)][int(o.y)]), // south-north
            vec2(Mx[int(!o.x)][int(o.x)], My[int(!o.x)][int(o.x)]) // west-east
        );

    minmax = select(!flip, minmax);
    minmax = swap(flip?!o.y:o.x, minmax);
    minmax += swap(flip?o.x:o.y, vec4(select(flip, l),select(flip, ll)));

    return
        block
        (
            minmax.xy + vec2(not(o)) - 1.0, minmax.zw + vec2(not(o)),
            tile + ivec2(not(o))
        );
}
/*
// original
// Inspired by https://www.shadertoy.com/view/Ws3GRs Asymmetric Blocks by Shane.
// Checkerboard tiling of alternating (horizontal vs. vertical) random (double-T-) crossings.
// Returns minimum and maximum corners of rectangle containing the given point an tile id.
block blocks(vec2 p) // https://www.shadertoy.com/view/dsdfDN rnd alternating T blocks circles
{
    vec2 q = fract(p); // local coordinates inside tile
    ivec2 tile = ivec2(floor(p)); // global coordinates of tile
    //bool flip = (tile.x % 2) == (tile.y % 2); // XXX breaks on windows XXX
    bool flip = (tile.x & 1) == (tile.y & 1);
    if(flip) // vertical line goes through
    {
        float x = hash(0+2*(tile)); // x-coordinate of vertical line through this tile
        float xsw = hash(0+2*(tile+ivec2(-1,-1))); // x-coordinate of vertical line through south-west tile
        float xnw = hash(0+2*(tile+ivec2(-1,+1))); // x-coordinate of vertical line through north-west tile
        float xse = hash(0+2*(tile+ivec2(+1,-1))); // x-coordinate of vertical line through south-east tile
        float xne = hash(0+2*(tile+ivec2(+1,+1))); // x-coordinate of vertical line through north-east tile
        float yw = hash(1+2*(tile+ivec2(-1, 0))); // y-coordinate of horizontal line through west tile
        float ye = hash(1+2*(tile+ivec2(+1, 0))); // y-coordinate of horizontal line through east tile
        float ys = hash(1+2*(tile+ivec2( 0,-1))); // y-coordinate of horizontal line through south tile
        float yn = hash(1+2*(tile+ivec2( 0,+1))); // y-coordinate of horizontal line through north tile

        if(q.x < x)
        {
            if(q.y < yw) return
                block
                (
                    vec2(xsw-1.0, ys-1.0), vec2(x, yw), // south-west
                    ivec2(tile.x + 0, tile.y + 0)
                );
            else return
                block
                (
                    vec2(xnw-1.0, yw), vec2(x, yn+1.0), // north-west
                    ivec2(tile.x + 0, tile.y + 1)
                );
        }
        else
        {
            if(q.y < ye) return
                block
                (
                    vec2(x, ys-1.0), vec2(xse+1.0, ye), // south-east
                    ivec2(tile.x + 1, tile.y + 0)
                );
            else return
                block
                (
                    vec2(x, ye), vec2(xne+1.0, yn+1.0), // north-east
                    ivec2(tile.x + 1, tile.y + 1)
                );
        }
    }
    else // horizontal line goes through
    {
        float y = hash(1+2*(tile)); // x-coordinate of horizontal line through this tile
        float ysw = hash(1+2*(tile+ivec2(-1,-1))); // y-coordinate of horizontal line through south-west tile
        float ynw = hash(1+2*(tile+ivec2(-1,+1))); // y-coordinate of horizontal line through north-west tile
        float yse = hash(1+2*(tile+ivec2(+1,-1))); // y-coordinate of horizontal line through south-east tile
        float yne = hash(1+2*(tile+ivec2(+1,+1))); // y-coordinate of horizontal line through north-east tile
        float xw = hash(0+2*(tile+ivec2(-1, 0))); // x-coordinate of vertical line through west tile
        float xe = hash(0+2*(tile+ivec2(+1, 0))); // x-coordinate of vertical line through east tile
        float xs = hash(0+2*(tile+ivec2( 0,-1))); // x-coordinate of vertical line through south tile
        float xn = hash(0+2*(tile+ivec2( 0,+1))); // x-coordinate of vertical line through north tile

        if(q.y < y)
        {
            if(q.x < xs) return
                block
                (
                    vec2(xw-1.0, ysw-1.0), vec2(xs, y), // south-west
                    ivec2(tile.x + 0, tile.y + 0)
                );
            else return
                block
                (
                    vec2(xs, yse-1.0), vec2(xe+1.0, y), // south-east
                    ivec2(tile.x + 1, tile.y + 0)
                );
        }
        else
        {
            if(q.x < xn) return
                block
                (
                    vec2(xw-1.0, y), vec2(xn, ynw+1.0), // north-west
                    ivec2(tile.x + 0, tile.y + 1)
                );
             else return
                block
                (
                    vec2(xn, y), vec2(xe+1.0, yne+1.0), // north-east
                    ivec2(tile.x + 1, tile.y + 1)
                );
        }
    }
}
*/
float circle(vec2 p, vec2 c, float r)
{
    return length(p - c) - r;
}
/*
float bounce(float t) // [0..1]
{
    return 1.0-2.0*abs(fract(t)-0.5);
}
*/
float bounce(float t) // [-1..+1]
{
    return 1.0-4.0*abs(fract(t)-0.5);
}

vec2 bounce(vec2 t) // [-1..+1]
{
    return 1.0-4.0*abs(fract(t)-0.5);
}

float map(vec2 p)
{
    block b = blocks(p);
    vec2 c = (b.p1 + b.p0) / 2.0;
    vec2 d = (b.p1 - b.p0) / 2.0;
    //float r = min(d.x, d.y);
    float r = min(d.x, d.y)/2.0;
    vec2 o = d - r;
    float distbox = interior_box(fract(p), b.p0, b.p1);
    //float distcirc = circle(fract(p), c, r);
    //float distcirc = circle(fract(p), c+o*cos(iTime), r);
    float distcirc = circle(fract(p), c+o*bounce(o.yx*iTime/5.0), r); // animated
    //return distbox;
    //return distcirc;
    return min(-distbox, distcirc);
    //return min(-distbox, abs(distcirc));
}

vec3 colorcode(ivec2 id)
{
    //return vec3(hash(id)); // randomize
    return vec3((id.x & 1) != (id.y & 1));
    //return vec3(vec2(id%4)/3.0,0.0);
}

#define scale 2.0

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec2 p = (2.0 * fragCoord - iResolution.xy) / iResolution.y;
    vec2 m = (2.0 * iMouse.xy - iResolution.xy) / iResolution.y;

    float d = map(p*scale)/scale;

    // sdf visualization by iq
    vec3 col = vec3(1.0) - sign(d) * vec3(0.1, 0.4, 0.7);
    col *= 1.0 - exp(-24.0 * abs(d));
    col *= 0.8 + 0.2 * cos(240.0*d);
    col = mix(col, vec3(1.0), 1.0 - smoothstep(0.0, 0.01, abs(d)));

    if(iMouse.z > 0.001)
    {
        col *= mix(vec3(0.5), vec3(1.0), colorcode(blocks(p*scale).id)); // visualize ids
        // sdf visualization by iq
        d = map(m*scale)/scale;
        col = mix(col, vec3(1.0,1.0,0.0), 1.0 - smoothstep(0.0, 0.005, abs(length(p - m) - abs(d)) - 0.0025));
        col = mix(col, vec3(1.0,1.0,0.0), 1.0 - smoothstep(0.0, 0.005, length(p - m) - 0.015));
    }

    fragColor = vec4(col, 1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

